<?php
require_once 'vendor/autoload.php';
require_once 'model/MongoDBConnection.php';
require_once 'model/KhachHang.php';

class ThuCung{
    private $collection;

    // Constructor để lấy collection 'thu_cung'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('thu_cung');
    }

    // Create: Thêm thú cưng mới
    public function addThuCung($data,  $idKhachHang) {
        // Thêm id_khach_hang vào dữ liệu thú cưng
        $data['id_khach_hang'] = new MongoDB\BSON\ObjectId($idKhachHang);

        $insertResult = $this->collection->insertOne($data);
        $petID = $insertResult->getInsertedId(); //Lấy _id thứ cưng

        $khachHang = new KhachHang();
        $khachHang->updateKhachHang($idKhachHang, $petID, 'add_pet');

        return (string) $petID;

    }

    // Update: Cập nhật thông tin thú cưng
    public function updateThuCung($id, $data) {
        //$data['id_khach_hang'] = new MongoDB\BSON\ObjectId($data['id_khach_hang']);

        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data] // Cập nhật thông tin thú cưng
        );
        return $updateResult->getModifiedCount(); // Số bản ghi bị thay đổi
    }

    // DELETE: Xóa thứ cưng
    public function deleteThuCung($id) {
        // Tìm thú cưng để lấy id_khach_hang
        $pet = $this->collection->findOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        if ($pet) {
            $customerId = $pet['id_khach_hang']; // Lấy id_khach_hang của thú cưng
            // Cập nhật khách hàng để xóa pet khỏi danh sách của khách hàng
            $khachHang = new KhachHang();
            $khachHang->updateKhachHang($customerId, $id, 'remove_pet');
        }

        $deleteResult = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $deleteResult->getDeletedCount(); // Trả về số bản ghi đã bị xóa
    }

    // Read all: Lấy danh sách tất cả khách hàng
    public function getAllThuCung() {
        $cursor = $this->collection->find();
        return iterator_to_array($cursor); // Chuyển kết quả tìm kiếm thành mảng
    }

    // Lấy thú cưng mới theo index 
    public function getThuCung($id, $type ="full-detail"){
        
        if ($type == "full-detail"){
            $cursor = $this->collection->findOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        } else {
            $cursor = $this->collection->findOne(
                ['_id' => new MongoDB\BSON\ObjectId($id)],
                [
                    'projection' => [
                        '_id' => 1,
                        'ten_thu_cung' => 1
                    ]
                ]
            );
        }

        return $cursor;
    }

}

?>