<?php

require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class PhanLoai{
    private $collection;
    
    // Constructor để lấy collection 'phan_loai'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('phan_loai');
    }

    // Thêm phân loại dịch vụ
    public function addPhanLoai($data) {
        $insertResult = $this->collection->insertOne($data);
        return (string) $insertResult->getInsertedId(); 
    }

    // Lấy danh sách tất cả phân loại theo type
    public function getAllPhanLoai($type = "hangHoa") {
        $cursor = $this->collection->find(['type' => $type])->toArray();
        return JSONHelper::removeOid($cursor);
    }


    // Cập nhật tên đơn vị
    public function updatePhanLoai($id, $data) {

        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data] // Cập nhật thông đơn vị
        );
        
        return $updateResult->getMatchedCount();
    }

    public function deletePhanLoai($id) {
        $deleteResult = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $deleteResult->getDeletedCount(); // Trả về số bản ghi đã bị xóa
    }
}

?>