<?php

require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';
require_once 'model/Bill.php';
require_once 'model/ThuCung.php';
require_once 'model/BenhAn.php';


class PetVisit{

    private $collection;
    
    // Constructor để lấy collection 'pet_visit'
    public function __construct() {
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('pet_visit');
    }


    public function addPetVisit($data){

        if (isset($data["id_thu_cung"]) && !empty($data["id_thu_cung"])){
            $data["id_thu_cung"] = new MongoDB\BSON\ObjectId($data["id_thu_cung"]);
        }

        if (isset($data["id_benh_an"]) && !empty($data["id_benh_an"])){
            $data["id_benh_an"] = new MongoDB\BSON\ObjectId($data["id_benh_an"]);
        }

        if (isset($data["id_bill"]) && !empty($data["id_bill"])){
            $data["id_bill"] = new MongoDB\BSON\ObjectId($data["id_bill"]);
        }

        if (isset($data["pre_id"]) && !empty($data["pre_id"])){
            $data["pre_id"] = new MongoDB\BSON\ObjectId($data["pre_id"]);
        }
        
        
        $insertResult = $this->collection->insertOne($data);
        return $insertResult->getInsertedId(); 
    }

        // Update: Cập nhật thông tin thú cưng
    public function updatePetVisit($id, $data) {
        
        if (isset($data["id_thu_cung"]) && !empty($data["id_thu_cung"])){
            $data["id_thu_cung"] = new MongoDB\BSON\ObjectId($data["id_thu_cung"]);
        }

        if (isset($data["id_benh_an"]) && !empty($data["id_benh_an"])){
            $data["id_benh_an"] = new MongoDB\BSON\ObjectId($data["id_benh_an"]);
        }

        if (isset($data["id_bill"]) && !empty($data["id_bill"])){
            $data["id_bill"] = new MongoDB\BSON\ObjectId($data["id_bill"]);
        }

        if (isset($data["pre_id"]) && !empty($data["pre_id"])){
            $data["pre_id"] = new MongoDB\BSON\ObjectId($data["pre_id"]);
        }

        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data] // Cập nhật thông tin thú cưng
        );
        return $updateResult->getModifiedCount(); // Số bản ghi bị thay đổi
    }


    // Read all: Lấy danh sách tất cả khách hàng
    public function getAllPetVisit() {
        $cursor = $this->collection->find();
        return iterator_to_array($cursor); // Chuyển kết quả tìm kiếm thành mảng
    }

    //Lấy info lần tái khám cuối cùng 
    public function getLastPetReVisit($idThuCung){
        
        $result = $this->collection->findOne(
            [
                'id_thu_cung' => new MongoDB\BSON\ObjectId($idThuCung),
                'type_pet_visit' => 'tai_kham'
            ],
            [
                'sort' => ['thoi_gian' => -1] // Sắp xếp giảm dần theo thời gian
            ]
        );

        return $result;
    }

    //Lấy info điều trị một chuỗi khám
    public function getListPetReVisit($idThuCung){

        $null = new MongoDB\BSON\ObjectId("000000000000000000000000");

        $result = [];
        
        $visit = $this->getLastPetReVisit($idThuCung);
        $result[] = $visit;
     
        while (true){
            if ($visit["pre_id"] == $null){
                break;
            }
                

            $visit = $this->collection->findOne(['_id' => $visit["pre_id"]]);
            $result[] = $visit;
        }

        return $result;

    }

    
}

?>