<?php

require_once 'vendor/autoload.php';

require_once 'controller/JSONHelper.php';
require_once 'controller/TimeHelper.php';

require_once 'model/MongoDBConnection.php';
require_once 'model/Inventory.php';


class NhapHangKho{
    private $collection;
    
    // Constructor để lấy collection 'xuat_chuyen_kho'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('nhap_hang_kho');
    }

    public function addNhapHangKho($data) {
        
        $data["create_time"] = TimeHelper::getCurTime();
        $data["id_chi_nhanh"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh"]);
        // Lưu phiếu nhập kho
        $insertResult = $this->collection->insertOne($data);

        $inventory = new Inventory();

        // Xử lý từng hàng hóa trong list
        foreach ($data["list_hang_hoa"] as $item) {

            // Lấy inventory hiện tại
            $inventoryItem = $inventory->getInventory(
                $data["id_chi_nhanh"],
                $item["id_hang_hoa"]
            );

            // Cộng tồn (nhập kho thì tăng số lượng)
            $inventoryItem["ton_kho"] = $inventoryItem["ton_kho"] + $item["so_luong"];

            $id = $inventoryItem["_id"];
            unset($inventoryItem["_id"]); // tránh lỗi ghi đè _id
            
            // Update inventory
            $inventory->updateInventory($id, $inventoryItem);
        }

        return (string) $insertResult->getInsertedId();
    }

    public function getAllNhapHangKho($id_chi_nhanh, $page = 1){
        $page = max(1, (int)$page);
        $limit = 15;
        $skip  = ($page - 1) * $limit;

        $filter = [
            'id_chi_nhanh' => new MongoDB\BSON\ObjectId($id_chi_nhanh)
        ];

        // Lấy danh sách phiếu xuất kho
        $cursor = $this->collection->find(
            $filter,
            [
                'skip'  => $skip,
                'limit' => $limit,
                'sort'  => ['_id' => -1]
            ]
        )->toArray();
        
        $inventory = new Inventory();

        // -------------------------
        // GẮN THÊM TEN_HANG_HOA + TEN_DON_VI TỪ INVENTORY
        // -------------------------
        foreach ($cursor as &$doc) {

            $doc["create_time"] = TimeHelper::convertObjectToTime($doc["create_time"], true);
            foreach ($doc["list_hang_hoa"] as &$item) {

                $inv = $inventory->getInventory(
                    $id_chi_nhanh,
                    $item["id_hang_hoa"]
                );

                if ($inv) {
                    $item["ten_hang_hoa"] = $inv["ten_hang_hoa"] ?? "";
                    $item["ten_don_vi"]   = $inv["ten_don_vi"] ?? "";
                } else {
                    // không có inventory
                    $item["ten_hang_hoa"] = null;
                    $item["ten_don_vi"]   = null;
                }
            }
        }

        // Convert OID → string
        $data = JSONHelper::removeOid($cursor);
        

        // Phân trang
        $totalItems = $this->collection->countDocuments($filter);
        $totalPages = ($totalItems > 0) ? ceil($totalItems / $limit) : 1;

        return [
            'transactions' => $data,
            'pagination' => [
                'page'        => $page,
                'total_items' => $totalItems,
                'total_pages' => $totalPages
            ]
        ];
    }


}
?>