<?php

// Include Composer autoloader
require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class NhaSanXuat{

    private $collection;

    // Constructor để lấy collection 'nha_san_xuat'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('nha_san_xuat');
    }

    public function addNhaSanXuat($data){
        $result = $this->collection->insertOne($data);
        return (string) $result->getInsertedId(); //trả về id của nhà sản xuất mới
    }

    // Update: Cập nhật thông tin NSX
    public function updateNhaSanXuat($id, $data) {
        
        //Sử dụng replaceOne để ghi đè mọi dữ liệu 
        $updateResult = $this->collection->replaceOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            $data
        );
        
        return $updateResult->getModifiedCount(); // Số bản ghi bị thay đổi
    }

    // Lấy danh sách tất cả nhà sản xuất
    public function getAllNhaSanXuat($type = "nhaSanXuat") {
        $cursor = $this->collection->find(['type' => $type])->toArray();
        return JSONHelper::removeOid($cursor);
    }


    // Xóa nhà sản xuất theo ID
    public function deleteNhaSanXuat($id) {
        $result = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $result->getDeletedCount();
    }

}

?>