<?php

// Include Composer autoloader
require_once 'vendor/autoload.php';

class MongoDBConnection {
    private static $instance = null;
    private $client;
    private $database;

    // Biến lưu trữ kết nối MongoDB
    private function __construct() {
        // Kết nối đến MongoDB (Thay đổi URI nếu cần)
        $this->client = new MongoDB\Client("mongodb://localhost:27017");
        $this->database = $this->client->DB_PET; 
    }

    // Hàm lấy kết nối MongoDB duy nhất
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new MongoDBConnection();
        }
        return self::$instance;
    }

    // Hàm để lấy collection
    public function getCollection($collectionName) {
        return $this->database->$collectionName;
    }
    
    // Ngăn không cho sao chép đối tượng
    private function __clone() {}
    public function __wakeup() {}
}
?>



