<?php

require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/TimeHelper.php';
require_once 'controller/JSONHelper.php';



class LichHen{
    private $collection;
    
    // Constructor để lấy collection 'lich_hen'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('lich_hen');
    }

    private function processData($data){
        
        //Kiểm tra những trường bắt buộc và thêm object

        if (isset($data["id_chi_nhanh"]) && !empty($data["id_chi_nhanh"])){
            $data["id_chi_nhanh"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh"]);
        } else {
            return false;
        }
       

        if (isset($data["id_khach_hang"]) && !empty($data["id_khach_hang"])){
       
            $data["id_khach_hang"] = new MongoDB\BSON\ObjectId($data["id_khach_hang"]);
        } else {
            return false;
        }
     
        
        if (isset($data["ngay_hen"]) && !empty($data["ngay_hen"])){
            $data["ngay_hen"] = TimeHelper::convertTimeToObject( $data["ngay_hen"]);
        } else {
            return false;
        }

        //Thêm object cho những trường còn lại 

        if (isset($data["id_thu_cung"]) && !empty($data["id_thu_cung"])){
            $data["id_thu_cung"] = new MongoDB\BSON\ObjectId($data["id_thu_cung"]);
        }

        if (isset($data["id_nhan_vien"]) && !empty($data["id_nhan_vien"])){
            $data["id_nhan_vien"] = new MongoDB\BSON\ObjectId($data["id_nhan_vien"]);
        }

    
        if (isset($data["dich_vu"]) && !empty($data["dich_vu"])){
            
            foreach ($data['dich_vu'] as &$dich_vu){
                $dich_vu['id_dich_vu'] = new MongoDB\BSON\ObjectId( $dich_vu['id_dich_vu']);
            }
        }

        return $data;
    }

    // Create: Thêm dịch vụ mới
    public function addLichHen($data) {
        
        $data =  $this->processData($data);
        if ($data == false ) return $data;

        $insertResult = $this->collection->insertOne($data);
        return (string) $insertResult->getInsertedId(); 
        
    }

    // Update: Cập nhật thông tin hàng hoá 
    public function updateLichHen($id, $data) {


        $data =  $this->processData( $data);
        
        if ($data == false ) return $data;


        //Sử dụng replaceOne để ghi đè mọi dữ liệu 
        $updateResult = $this->collection->replaceOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            $data
        );

        return $updateResult->getModifiedCount(); // Số bản ghi bị thay đổi
    }

    // DELETE: Xóa lịch hẹn
    public function deleteLichHen($id) {
        $deleteResult = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $deleteResult->getDeletedCount(); // Trả về số bản ghi đã bị xóa
    }

    //Tự động xoá các lịch hẹn đã quá hạn 4 ngày 
    private function autoDeleteLichHen(){
        // Thời điểm hiện tại (UTC)
        $now = new DateTime('now', new DateTimeZone('UTC'));

        // Lùi tối đa 4 ngày
        $now->modify('-4 days');

        // Convert sang BSON UTCDateTime
        $limitDate = new MongoDB\BSON\UTCDateTime($now->getTimestamp() * 1000);

        // Xóa tất cả lịch hẹn có ngày < limitDate
        $this->collection->deleteMany([
            'ngay_hen' => ['$lt' => $limitDate]
        ]);
    
    }

    // Lấy tất cả lịch hẹn theo chi nhánh 
    public function getAllLichHen($idChiNhanh){
        
        //tự động xoá những lịch hẹn đã lố ngày 
        $this->autoDeleteLichHen();

        $cursor = $this->collection->find(
            [
                'id_chi_nhanh' => new MongoDB\BSON\ObjectId($idChiNhanh)
            ],
            [
                'sort' => ['ngay_hen' => 1]  // 1 = tăng dần
            ]
        );

        $results = iterator_to_array($cursor);

        foreach ($results as &$item) {
             if (!empty($item['ngay_hen'])) {
                $item['ngay_hen'] = TimeHelper::convertObjectToTime( $item['ngay_hen'], true);
            }
        }

        return JSONHelper::removeOid($results);

    }
}

?>