<?php

require_once 'vendor/autoload.php';

require_once 'controller/JSONHelper.php';

require_once 'model/MongoDBConnection.php';
require_once 'model/Inventory.php';

class KiemToanKho{

    private $collection;
    
    // Constructor để lấy collection 'kiem_toan_kho'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('kiem_toan_kho');
    }

    public function addKiemToanKho($data){

        $inventory = new Inventory();

        // -----------------------------
        // Xử lý kiểm toán cho từng hàng hóa
        // -----------------------------
        foreach ($data["list_hang_hoa"] as &$item) {

            // Lấy tồn hiện tại trong DB
            $inventoryItem = $inventory->getInventory(
                $data["id_chi_nhanh"],
                $item["id_hang_hoa"]
            );

            // -----------------------------
            // Tính toán kiểm kê
            // -----------------------------
            $ton_so_sach = (int)$inventoryItem["ton_kho"];
            $ton_thuc_te  = (int)$item["ton_thuc_te"];
            $chenh_lech   = $ton_thuc_te - $ton_so_sach;

            // Lưu vào phiếu kiểm toán
            $item["ton_so_sach"] = $ton_so_sach;
            $item["chenh_lech"]   = $chenh_lech;

            // -----------------------------
            // Cập nhật lại tồn kho = tồn thực tế
            // -----------------------------
            $id = $inventoryItem["_id"];
            unset($inventoryItem["_id"]);

            $inventoryItem["ton_kho"] = $ton_thuc_te;

            $inventory->updateInventory($id, $inventoryItem);
        }

        // -----------------------------
        // Lưu phiếu kiểm toán vào collection hiện tại
        // -----------------------------
        $data["id_chi_nhanh"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh"]);
        $insertResult = $this->collection->insertOne($data);

        return (string)$insertResult->getInsertedId();
    }


    public function getAllKiemToanKho($id_chi_nhanh, $page = 1){
        $page = max(1, (int)$page);
        $limit = 15;
        $skip  = ($page - 1) * $limit;

        $filter = [
            'id_chi_nhanh' => new MongoDB\BSON\ObjectId($id_chi_nhanh)
        ];

        // Lấy danh sách phiếu xuất kho
        $cursor = $this->collection->find(
            $filter,
            [
                'skip'  => $skip,
                'limit' => $limit,
                'sort'  => ['_id' => -1]
            ]
        )->toArray();

        $inventory = new Inventory();

        // -------------------------
        // GẮN THÊM TEN_HANG_HOA + TEN_DON_VI TỪ INVENTORY
        // -------------------------
        foreach ($cursor as &$doc) {

            foreach ($doc["list_hang_hoa"] as &$item) {

                $inv = $inventory->getInventory(
                    $id_chi_nhanh,
                    $item["id_hang_hoa"]
                );

                if ($inv) {
                    $item["ten_hang_hoa"] = $inv["ten_hang_hoa"] ?? "";
                    $item["ten_don_vi"]   = $inv["ten_don_vi"] ?? "";
                } else {
                    // không có inventory
                    $item["ten_hang_hoa"] = null;
                    $item["ten_don_vi"]   = null;
                }
            }
        }

        // Convert OID → string
        $data = JSONHelper::removeOid($cursor);

        // Phân trang
        $totalItems = $this->collection->countDocuments($filter);
        $totalPages = ($totalItems > 0) ? ceil($totalItems / $limit) : 1;

        return [
            'transactions' => $data,
            'pagination' => [
                'page'        => $page,
                'total_items' => $totalItems,
                'total_pages' => $totalPages
            ]
        ];
    }


}