<?php

// Include Composer autoloader
require_once 'vendor/autoload.php';

require_once 'controller/JSONHelper.php';

require_once 'model/MongoDBConnection.php';


class Inventory {
    private $collection;

    // Constructor để lấy collection 'inventory'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('inventory');
    }
    
    public function addInventory($data){
        $result = $this->collection->insertOne($data);
        return $result->getInsertedId(); //trả về id của Inventory
    }

    // Update: Cập nhật thông tin Inventory
    public function updateInventory($id, $data) {
        
        
        $data['id_chi_nhanh'] = new MongoDB\BSON\ObjectId($data['id_chi_nhanh']);
        $data['id_hang_hoa']  = new MongoDB\BSON\ObjectId($data['id_hang_hoa']);
        
        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data] // Cập nhật thông tin nhà Inventory
        );
        return $updateResult->getModifiedCount(); // Số bản ghi bị thay đổi
    }

    function getInventory($id_chi_nhanh, $id_hang_hoa) {

        // Tìm tài liệu inventory theo chi nhánh + hàng hóa
        $document = $this->collection->findOne([
            'id_chi_nhanh' => new MongoDB\BSON\ObjectId($id_chi_nhanh),
            'id_hang_hoa'  => new MongoDB\BSON\ObjectId($id_hang_hoa)
        ]);

        if ($document) {
            // Nếu muốn trả về dạng mảng đã remove ObjectId
            return JSONHelper::removeOid($document);
        }
    
        return null; // Không tìm thấy
    }


    public function getAllInventory($data){
        // Đảm bảo page >= 1
        
        $page = max(1, (int)$data["page"]);
        $limit = 15;
        $skip  = ($page - 1) * $limit;

        // Base filter theo chi nhánh
        $filter = [
            'id_chi_nhanh' => new MongoDB\BSON\ObjectId($data["id_chi_nhanh"])
        ];


        // Filter theo keyword
        if (!empty($data["kw"])) {
            $filter['ten_hang_hoa'] = new MongoDB\BSON\Regex($data["kw"], "i");
        }

        
        // Filter theo type
        if ($data["type"] === "het_hang") {
            // tồn kho = 0
            $filter['ton_kho'] = 0;

        } elseif ($data["type"] === "gan_het_hang") {
            // tồn kho <= tồn tối thiểu
            $filter['$expr'] = [
                '$lte' => ['$ton_kho', '$ton_toi_thieu']
            ];
        }
        // type = normal → không thêm filter


        // Tổng số bản ghi
        $totalItems = $this->collection->countDocuments($filter);
        $totalPages = ($totalItems > 0) ? ceil($totalItems / $limit) : 1;

        // Lấy dữ liệu theo trang
        $cursor = $this->collection->find(
            $filter,
            [
                'skip'  => $skip,
                'limit' => $limit,
                'sort'  => ['ten_hang_hoa' => 1]
            ]
        )->toArray();

        // Chuẩn dạng JSON
        $result = JSONHelper::removeOid($cursor);

        return [
            'data' => $result,
            'pagination' => [
                'page'        => $page,
                'total_items' => $totalItems,
                'total_pages' => $totalPages
            ]
        ];
    }


}
    
?>