<?php

require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class DonVi{
    private $collection;
    
    // Constructor để lấy collection 'don_vi'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('don_vi');
    }

    // Thêm đơn vị mới 
    public function addDonVi($data) {
        $insertResult = $this->collection->insertOne($data);
        return (string) $insertResult->getInsertedId(); 
    }

    // Lấy danh sách tất cả đơn vị
    public function getAllDonVi($type = "hangHoa") {
        $cursor = $this->collection->find(['type' => $type])->toArray();
        return JSONHelper::removeOid($cursor);
    }

    // Cập nhật tên đơn vị
    public function updateDonVi($id, $data) {

        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data] // Cập nhật thông đơn vị
        );
        
        return $updateResult->getMatchedCount();
    }

    public function deleteDonVi($id) {
        $deleteResult = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $deleteResult->getDeletedCount(); // Trả về số bản ghi đã bị xóa
    }
}

?>