<?php

require_once 'vendor/autoload.php';

require_once 'controller/JSONHelper.php';

require_once 'model/MongoDBConnection.php';
require_once 'model/Inventory.php';

class ChuyenXuatKho{
    private $collection;
    
    // Constructor để lấy collection 'xuat_chuyen_kho'
    public function __construct() {

        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('chuyen_xuat_kho');
    }

    public function addXuatKho($data) {
        // Lưu phiếu xuất
        $data["id_chi_nhanh"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh"]);
        $insertResult = $this->collection->insertOne($data);

        $inventory = new Inventory();

        // Xử lý nhiều hàng hóa trong list
        foreach ($data["list_hang_hoa"] as $item) {

            // Lấy inventory hiện tại
            $inventoryItem = $inventory->getInventory(
                (string)$data["id_chi_nhanh"],
                (string)$item["id_hang_hoa"]
            );

            // Trừ tồn
            $inventoryItem["ton_kho"] = $inventoryItem["ton_kho"] - $item["so_luong"];

            // Lấy ID để update
            $id = $inventoryItem["_id"];
            unset($inventoryItem["_id"]);

            // Update lại inventory
            $inventory->updateInventory($id, $inventoryItem);
        }

        return (string) $insertResult->getInsertedId(); 
    }

    public function addChuyenKho($data) {

        // Lưu phiếu chuyển kho 
        $data["id_chi_nhanh"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh"]);
        $data["id_chi_nhanh_chuyen"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh_chuyen"]);

        $insertResult = $this->collection->insertOne($data);

        $inventory = new Inventory();

        $idChiNhanhXuat   = (string) $data["id_chi_nhanh"];
        $idChiNhanhNhap   = (string) $data["id_chi_nhanh_chuyen"];

        foreach ($data["list_hang_hoa"] as $item) {

            // =========================
            // 1. TRỪ TỒN Ở CHI NHÁNH XUẤT
            // =========================

            $invXuat = $inventory->getInventory($idChiNhanhXuat, $item["id_hang_hoa"]);

            $invXuat["ton_kho"] = $invXuat["ton_kho"] - $item["so_luong"];

            $idXuat = $invXuat["_id"];
            unset($invXuat["_id"]);

            $inventory->updateInventory($idXuat, $invXuat);


            // =========================
            // 2. CỘNG TỒN Ở CHI NHÁNH CHUYỂN (CHI NHÁNH NHẬN)
            // always EXIST — theo yêu cầu
            // =========================

            $invNhap = $inventory->getInventory($idChiNhanhNhap, $item["id_hang_hoa"]);

            $invNhap["ton_kho"] = $invNhap["ton_kho"] + $item["so_luong"];

            $idNhap = $invNhap["_id"];
            unset($invNhap["_id"]);

            $inventory->updateInventory($idNhap, $invNhap);
        }

        return (string)$insertResult->getInsertedId();
    }

    public function getAllChuyenXuatKho($id_chi_nhanh, $page = 1){
        $page = max(1, (int)$page);
        $limit = 15;
        $skip  = ($page - 1) * $limit;

        $filter = [
            'id_chi_nhanh' => new MongoDB\BSON\ObjectId($id_chi_nhanh)
        ];

        // Lấy danh sách phiếu xuất kho
        $cursor = $this->collection->find(
            $filter,
            [
                'skip'  => $skip,
                'limit' => $limit,
                'sort'  => ['_id' => -1]
            ]
        )->toArray();

        $inventory = new Inventory();

        // -------------------------
        // GẮN THÊM TEN_HANG_HOA + TEN_DON_VI TỪ INVENTORY
        // -------------------------
        foreach ($cursor as &$doc) {

            foreach ($doc["list_hang_hoa"] as &$item) {

                $inv = $inventory->getInventory(
                    $id_chi_nhanh,
                    $item["id_hang_hoa"]
                );

                if ($inv) {
                    $item["ten_hang_hoa"] = $inv["ten_hang_hoa"] ?? "";
                    $item["ten_don_vi"]   = $inv["ten_don_vi"] ?? "";
                } else {
                    // không có inventory
                    $item["ten_hang_hoa"] = null;
                    $item["ten_don_vi"]   = null;
                }
            }
        }

        // Convert OID → string
        $data = JSONHelper::removeOid($cursor);

        // Phân trang
        $totalItems = $this->collection->countDocuments($filter);
        $totalPages = ($totalItems > 0) ? ceil($totalItems / $limit) : 1;

        return [
            'transactions' => $data,
            'pagination' => [
                'page'        => $page,
                'total_items' => $totalItems,
                'total_pages' => $totalPages
            ]
        ];
    }

}

?>