<?php

require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class ChuyenNghanh{
    private $collection;
    
    // Constructor để lấy collection 'chuyen_nghanh'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('chuyen_nghanh');
    }

    // Thêm chuyên nghành mới
    public function addChuyenNghanh($data) {
        $insertResult = $this->collection->insertOne($data);
        return (string) $insertResult->getInsertedId(); 
    }

    // Lấy danh sách tất cả chuyên nghành
    public function getAllChuyenNganh() {
        $cursor = $this->collection->find()->toArray();
        return JSONHelper::removeOid($cursor);
    }

    // Cập nhật chuyên nghành
    public function updateChuyenNghanh($id, $data) {

        $updateResult = $this->collection->replaceOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            $data
        );
        
        return $updateResult->getMatchedCount();
    }

    //Get info của chuyên nghành 
    public function getChuyenNghanh($id){
        $cursor = $this->collection->findOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return JSONHelper::removeOid($cursor);
    }

}
?>