<?php

// Include Composer autoloader
require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class ChiNhanh {
    private $collection;

    // Constructor để lấy collection 'chi_nhanh'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('chi_nhanh');
    }

    // Thêm chi nhánh mới
    public function addChiNhanh($data) {

        $insertResult = $this->collection->insertOne($data);
        return (string) $insertResult->getInsertedId(); 
    
    }

    // Lấy danh sách tất cả chi nhánh
    public function getAllChiNhanh() {
        $cursor = $this->collection->find()->toArray();
         return JSONHelper::removeOid($cursor);
    }

    // Cập nhật tên chi nhánh
    public function updateChiNhanh($id, $data) {
        
        // Cập nhật thông tin chi nhánh
        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data]
        );
        
        return $updateResult->getModifiedCount(); // Trả về số bản ghi bị thay đổi

    }

    //Get chi nhánh theo _id
    public function getChiNhanh($id){
        $cursor = $this->collection->findOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return JSONHelper::removeOid($cursor);
    }

    /*public function deleteChiNhanh($id) {
        $deleteResult = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $deleteResult->getDeletedCount(); // Trả về số bản ghi đã bị xóa
    }*/
}
?>
