<?php

require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class CachDung{
    private $collection;
    
    // Constructor để lấy collection 'cach_dung'
    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('cach_dung');
    }

    // Thêm cách dùng mới
    public function addCachDung($tenCachDung) {
        $insertResult = $this->collection->insertOne([
            'ten_cach_dung' => $tenCachDung
        ]);
        
        return (string) $insertResult->getInsertedId();
    }

    // Lấy danh sách tất cả cách dùng
    public function getAllCachDung() {
        $cursor = $this->collection->find()->toArray();
        return JSONHelper::removeOid($cursor);
    }

    // Cập nhật tên cách dùng
    public function updateCachDung($id, $data) {

        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data] // Cập nhật thông cách dùng
        );
        
        return $updateResult->getMatchedCount();
    }

    public function deleteCachDung($id) {
        $deleteResult = $this->collection->deleteOne(['_id' => new MongoDB\BSON\ObjectId($id)]);
        return $deleteResult->getDeletedCount(); // Trả về số bản ghi đã bị xóa
    }
}

?>