<?php
require_once 'vendor/autoload.php';

require_once 'model/MongoDBConnection.php';

require_once 'controller/JSONHelper.php';

class Bill{
    private $collection;


    public function __construct() {
        // Lấy kết nối MongoDB
        $mongoDB = MongoDBConnection::getInstance();
        $this->collection = $mongoDB->getCollection('bill');
    }

    private function processData($data){
        
        //Kiểm tra những trường bắt buộc và thêm object
       
        if (isset($data["id_chi_nhanh"]) && !empty($data["id_chi_nhanh"])){
            $data["id_chi_nhanh"] = new MongoDB\BSON\ObjectId($data["id_chi_nhanh"]);
        }

        if (isset($data["id_khach_hang"]) && !empty($data["id_khach_hang"])){
            $data["id_khach_hang"] = new MongoDB\BSON\ObjectId($data["id_khach_hang"]);
        }

        if (isset($data["id_thu_cung"]) && !empty($data["id_thu_cung"])){
            $data["id_thu_cung"] = new MongoDB\BSON\ObjectId($data["id_thu_cung"]);
        }

        if (isset($data["id_nhan_vien"]) && !empty($data["id_nhan_vien"])){
            $data["id_nhan_vien"] = new MongoDB\BSON\ObjectId($data["id_nhan_vien"]);
        } else {
            return false;
        }

    
        //---------------------------------------
        // Xử lý DỊCH VỤ (dich_vu)
        //---------------------------------------
        if (isset($data["dich_vu"])) {

            foreach ($data["dich_vu"] as &$dich_vu) {

                // Convert id_dich_vu
                if (isset($dich_vu["id_dich_vu"]) ) {
                    $dich_vu["id_dich_vu"] = new MongoDB\BSON\ObjectId($dich_vu["id_dich_vu"]);
                }

                // Xử lý list hàng hóa của dịch vụ
                if (isset($dich_vu["list_hang_hoa"]) ) {

                    foreach ($dich_vu["list_hang_hoa"] as &$hh) {

                        if (isset($hh["id_hang_hoa"])) {
                            $hh["id_hang_hoa"] = new MongoDB\BSON\ObjectId($hh["id_hang_hoa"]);
                        }

                        // so_luong giữ nguyên
                    }
                    unset($hh); // tránh reference leak
                }
            }
            unset($dich_vu); // tránh reference leak
        }

        //---------------------------------------
        // Xử lý HÀNG HÓA LẺ KHÔNG THUỘC DỊCH VỤ NÀO
        //---------------------------------------
        if (isset($data["hang_hoa"])) {

            foreach ($data["hang_hoa"] as &$item) {

                if (isset($item["id_hang_hoa"]) ) {
                    $item["id_hang_hoa"] = new MongoDB\BSON\ObjectId($item["id_hang_hoa"]);
                }
            }
            unset($item);
        }

        return $data;
    }

    public function addBill($data){
        $data = $this->processData($data);

        if ($data == false)
            return $data; 

        $insertResult = $this->collection->insertOne($data);
        return (string) $insertResult->getInsertedId(); 
    }

    public function updateBill($data){
        $data = $this->processData($data);

        // Cập nhật thông tin bill
        $updateResult = $this->collection->updateOne(
            ['_id' => new MongoDB\BSON\ObjectId($id)],
            ['$set' => $data]
        );
        
        return $updateResult->getModifiedCount(); // Trả về số bản ghi bị thay đổi

    }

    
}

?>