<?php

require_once 'vendor/autoload.php';

use Endroid\QrCode\QrCode;
use Endroid\QrCode\Color\ColorInterface;
use Endroid\QrCode\Writer\PngWriter;

class TimeHelper{
    
    public static function getCurTime(){
        
        return  new MongoDB\BSON\UTCDateTime();
    }

    
    //Convert thời gian qua MongoDB time object để lưu db $dateString có định đang 2025-07-30 15:05:25 
    public static function convertTimeToObject($dateString){
        // Tạo DateTime với timezone Việt Nam
        $date = new DateTime($dateString, new DateTimeZone('Asia/Ho_Chi_Minh'));

        // Convert sang UTC
        $date->setTimezone(new DateTimeZone('UTC'));

        $milliseconds = $date->getTimestamp() * 1000;

        return new MongoDB\BSON\UTCDateTime($milliseconds);
    }

    public static function convertObjectToTime($objDate, $isHour = false){
        $dateTime = $objDate->toDateTime();
        $dateTime->setTimezone(new DateTimeZone('Asia/Ho_Chi_Minh'));
        if ($isHour){
            return $dateTime->format('d-m-Y H:i');
        } else {
            return $dateTime->format('d-m-Y');
        }
    }

    

}

?>