<?php

require_once 'vendor/autoload.php';

require_once 'controller/CSVHelper.php';
require_once 'controller/StringHelper.php';


use Picqer\Barcode\BarcodeGeneratorPNG;


class PrintHelper{

    public static function getQRTransfer($bankBame, $accountNo, $amount, $description, $accountName){

        $bankId = CSVHelper::getBankCodeFromCSV($bankBame);
        $template = 'compact2';  // Template QR (compact, full, v.v.)
        $description = urlencode(StringHelper::convertText($description));
        $accountName = urlencode(StringHelper::convertText($accountName)); 

        // Tạo URL cho mã QR theo cấu trúc VietQR
        $qrUrl = "https://img.vietqr.io/image/$bankId-$accountNo-$template.png?amount=$amount&addInfo=$description&accountName=$accountName";
        return $qrUrl;
    }

    public static function printBarcode($productBarcode, $num){
        
        $generator = new BarcodeGeneratorPNG();
        $barcodes = [];

        for ($i = 0; $i < $num; $i++) {
            $barcode = $generator->getBarcode($productBarcode, BarcodeGeneratorPNG::TYPE_CODE_128);
            $barcodes[] = base64_encode($barcode); // Lưu mã vạch dưới dạng base64 để nhúng vào HTML
        }

        return $barcodes;
    }

}

?>