<?php

require_once 'vendor/autoload.php';

class JSONHelper{

    // Hàm chuyển đổi object sang JSON
    public static function objectToJson($object) {
        // Đảm bảo tất cả các chuỗi trong đối tượng là UTF-8
        array_walk_recursive($object, function (&$value) {
            if (is_string($value)) {
                // Chuyển mã hóa thành UTF-8 nếu chưa phải
                $value = mb_convert_encoding($value, 'UTF-8', 'UTF-8');
            }
        });

        // Chuyển đối tượng thành JSON, giữ nguyên ký tự UTF-8
        return json_encode($object, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);  
    }

    //Hàm xoá oid 
    public static function removeOid($data) {

    // Nếu là ObjectId thật trong PHP driver → convert sang string
    if ($data instanceof MongoDB\BSON\ObjectId) {
        return (string) $data;
    }

    // Nếu là object (stdClass, bsonDocument...) → convert sang array để xử lý tiếp
    if (is_object($data)) {
        $data = (array)$data;
    }

    // Nếu là mảng
    if (is_array($data)) {

        // Nếu là dạng {"$oid": "..."} → trả về chuỗi hex 24
        if (isset($data['$oid']) && count($data) === 1) {
            return $data['$oid'];
        }

        // Duyệt từng phần tử (đệ quy)
        foreach ($data as $key => $value) {
            $data[$key] = self::removeOid($value);
        }

        return $data;
    }

    // Những giá trị khác giữ nguyên
    return $data;
}

    
}

?>