<?php

require_once 'vendor/autoload.php';

class CSVHelper{

    public static function getBankCodeFromCSV( $searchValue) {

        $csvBankFile = 'bank_info.csv';
        
        // Mở file CSV
        if (($handle = fopen($csvBankFile, 'r')) !== false) {
            $header = fgetcsv($handle);  // Đọc tiêu đề cột (name, shortName, code)
            
            // Lặp qua các dòng của file CSV
            while (($data = fgetcsv($handle)) !== false) {
                // Tạo mảng với tên cột tương ứng
                $bank = array_combine($header, $data);
                
                // Kiểm tra nếu tên hoặc shortName trùng khớp
                if (strcasecmp($bank['name'], $searchValue) == 0 || strcasecmp($bank['shortName'], $searchValue) == 0) {
                    fclose($handle);  // Đóng file sau khi tìm thấy kết quả
                    return $bank['code'];  // Trả về mã ngân hàng
                }
            }
            
            fclose($handle);  // Đóng file nếu không tìm thấy
        }
        
        return null;  // Nếu không tìm thấy, trả về null
    }

}

?>