<?php


// ===== CORS ALLOW ALL =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

#############################################################################

require_once 'vendor/autoload.php';

require_once 'model/NhanVien.php';
require_once 'model/ChiNhanh.php';
require_once 'model/ChuyenNghanh.php';

require_once 'controller/ResponseHelper.php';

use Symfony\Component\HttpFoundation\Request;


$request = Request::createFromGlobals();

if (!in_array($request->getMethod(),['POST','GET'])) {
    ResponseHelper::responseError("Only POST method allowed");
}  

// Đọc dữ liệu JSON gửi lên
$data = json_decode($request->getContent(), true);

// Kiểm tra dữ liệu hợp lệ
if (!$data || !isset($data['action'])) {
    ResponseHelper::responseError("Invalid input, required field: action");
}

$nhanVien = new NhanVien();
$chiNhanh = new ChiNhanh();
$chuyenNghanh = new chuyenNghanh();

#############################################################################

//Function thêm chuyên nghành
if ($data['action'] == 'addChuyenNghanh'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['ten_chuyen_nghanh']))){
        try{
            $result = $chuyenNghanh->addChuyenNghanh($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa chuyên nghành
if ($data['action'] == 'updateChuyenNghanh'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $chuyenNghanh->updateChuyenNghanh($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Fucntion lấy tất cả chuyên nghành
if ($data['action'] == 'getAllChuyenNghanh'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $chuyenNghanh->getAllChuyenNganh();
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}


//Function getChuyenNghanh
if ($data['action'] == 'getChuyenNghanh'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Get Fail");
    }

    try{
        $result = $chuyenNghanh->getChuyenNghanh($data["_id"]);
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}
#############################################################################

//Function thêm chi nhánh
if ($data['action'] == 'addChiNhanh'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['ten_chi_nhanh']))){
        try{
            $result = $chiNhanh->addChiNhanh($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa chi nhánh
if ($data['action'] == 'updateChiNhanh'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $chiNhanh->updateChiNhanh($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Function get Chi Nhánh theo _id

if ($data['action']== 'getChiNhanh'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Get Fail");
    }

    try{
        $result = $chiNhanh->getChiNhanh($data["_id"]);
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }  
}

//Fucntion lấy tất cả chi nhánh
if ($data['action'] == 'getAllChiNhanh'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $chiNhanh->getAllChiNhanh();
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }    
}

#############################################################################

//Function Add Nhân Viên mới 
if ($data['action'] == 'addNhanVien'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['ten_nhan_vien']))){
        try{
            $result = $nhanVien->addNhanVien($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }    
}

//Fucntion lấy tất cả chuyên nghành
if ($data['action'] == "getAllNhanVien"){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (empty($data["page"])){
        ResponseHelper::responseError("Get Fail");
    }

    try{
        $result = $nhanVien->getAllNhanVien();
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}

//Function update nhân viên
if ($data['action'] == 'resetMatKhau'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    try{
        $result = $nhanVien->resetPassword($data, "forgot");
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Reset Fail");
    }


    if ($result == false ){
        ResponseHelper::responseError("Reset Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }
}

//Function login Nhân Viên 
if ($data['action'] == 'loginNhanVien'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['username'])) && (!empty($data['mat_khau']))){
        try{
            
            $result = $nhanVien->loginNhanVien($data);

            if ($data == null){
                ResponseHelper::responseError("Login Fail");
            }

            ResponseHelper::responseSuccess($result);

        } catch (Throwable  $e){
            ResponseHelper::responseError("Login Fail");
        }
    } else {
        ResponseHelper::responseError("Login Fail");
    }
}

//Function thay đổi mat_khau

if ($data['action'] == 'changeMatKhau'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ($data["mat_khau"] == $data["xac_nhan_mat_khau"]){
        try{
            $result = $nhanVien->updatePassword($data);
            if ($result == false){
                ResponseHelper::responseError("Change Fail");
            } else {
                ResponseHelper::responseSuccess($result);
            }

        } catch (Throwable  $e){
            ResponseHelper::responseError("Change Fail");
        }
    } else {
        ResponseHelper::responseError("Change Fail");
    } 

}


//Function update nhân viên

if ($data['action'] == 'updateNhanVien'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    
    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $nhanVien->updateNhanVien($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }

  
    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}