<?php 


// ===== CORS ALLOW ALL =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

#############################################################################

require_once 'vendor/autoload.php';

require_once 'model/LichHen.php';
require_once 'model/KhachHang.php';
require_once 'model/DichVu.php';

require_once 'controller/ResponseHelper.php';

use Symfony\Component\HttpFoundation\Request;

$request = Request::createFromGlobals();

if (!in_array($request->getMethod(),['POST','GET'])) {
    ResponseHelper::responseError("Only POST method allowed");
}  

// Đọc dữ liệu JSON gửi lên
$data = json_decode($request->getContent(), true);

// Kiểm tra dữ liệu hợp lệ
if (!$data || !isset($data['action'])) {
    ResponseHelper::responseError("Invalid input, required field: action");
}

$lichHen = new LichHen();
$khachHang = new KhachHang();
$dichVu = new DichVu();

#############################################################################

// Function add lịch hẹn mới 
if ($data['action'] == 'addLichHen'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $lichHen->addLichHen($data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Add Fail");
    }
    

    if ($result == false){
        ResponseHelper::responseError("Add Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

// Function update Lịch Hẹn 
if ($data['action'] == 'updateLichHen'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $lichHen->updateLichHen($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == false || $result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

// Function delete Lịch Hẹn 
if ($data['action'] == 'deleteLichHen'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["_id"]) && !empty($data["_id"]))){
         ResponseHelper::responseError("Delete Fail");
    }

    try{
    
        $result = $lichHen->deleteLichHen($data["_id"]);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Delete Fail");
    }

    
    if ($result == 0 ){
        
        ResponseHelper::responseError("Delete Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

// Function getAll Lịch Hẹn theo chi nhánh 
if ($data['action'] == 'getAllLichHen'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["id_chi_nhanh"]) && !empty($data["id_chi_nhanh"]))){
         ResponseHelper::responseError("Get All Fail");
    }

    try{
        $result = $lichHen->getAllLichHen($data["id_chi_nhanh"]);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }

    ResponseHelper::responseSuccess($result);

}

//Function get Khách Hàng và pets thông tin nhỏ gọn
if ($data['action'] == 'getKhachHangWithPets'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
            $result = $khachHang->getKhachHangWithPets($data['_id'], "part-detail");
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseSuccess(null);
        }
        
    } else {
        ResponseHelper::responseSuccess(null);
    }

}


?>