<?php


// ===== CORS ALLOW ALL =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

#############################################################################

require_once 'vendor/autoload.php';

require_once 'model/KhachHang.php';
require_once 'model/ThuCung.php';

require_once 'controller/ResponseHelper.php';
require_once  'controller/TimeHelper.php';

use Symfony\Component\HttpFoundation\Request;


$request = Request::createFromGlobals();

if (!in_array($request->getMethod(),['POST','GET'])) {
    ResponseHelper::responseError("Only POST method allowed");
}  

// Đọc dữ liệu JSON gửi lên
$data = json_decode($request->getContent(), true);

// Kiểm tra dữ liệu hợp lệ
if (!$data || !isset($data['action'])) {
    ResponseHelper::responseError("Invalid input, required field: action");
}

$khachHang = new KhachHang();
$thuCung = new ThuCung();

#############################################################################

// Function thêm khách hàng mới 
if ($data['action'] == 'addKhachHang'){

    //Xoá action để thêm data vào 
    unset($data['action']);


    if ((isset($data['ten_khach_hang'])&& isset($data['so_dien_thoai']))){
        
        try{
            if ($khachHang->isExistsSDT($data['so_dien_thoai'])){
                ResponseHelper::responseError("Số điện thoại đã tồn tại");
            } else {

                $data["created_time"] = TimeHelper::getCurTime();
                $result = $khachHang->addKhachHang($data);

                ResponseHelper::responseSuccess($result);
            }
            
        }catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
        
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}


//Function update khách hàng 
if ($data['action'] == 'updateKhachHang'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);

    try{
        $result = $khachHang->updateKhachHang($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == false || $result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }
}

// Function thêm thú cưng mới 
if ($data['action'] == 'addThuCung'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    
    if (empty($data['id_khach_hang'])){
        ResponseHelper::responseError("Add Fail");
    }

    
    if ((!empty($data['ten_thu_cung']) && !empty($data['loai']) )){

        try{
            
            $idKhachHang = $data['id_khach_hang'];
            $result = $thuCung->addThuCung($data, $idKhachHang);
            ResponseHelper::responseSuccess($result);
        
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
        
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function update thông tin thú cưng
if ($data['action'] == 'updateThuCung'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);

    try{
        $result = $thuCung->updateThuCung($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == false || $result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }
}

//Function delete thứ cưng 

if ($data['action'] == 'deleteThuCung'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
            $result = $thuCung->deleteThuCung($data['_id']);
            
            if ($result == 1){
                ResponseHelper::responseSuccess($result);
            }else {
                ResponseHelper::responseError("Delete Fail");
            }
        } catch (Throwable  $e){
            ResponseHelper::responseError("Delete Fail");
        }
    } else {
        ResponseHelper::responseError("Delete Fail");
    }

}

//Function autocomplete khách hàng 
if ($data['action'] == 'autoCompleteKhachHang'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['kw'])){
        try{
            $result = $khachHang->autoCompleteKhachHang($data['kw']);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseSuccess(null);
        }
        
    } else {
        ResponseHelper::responseSuccess(null);
    }

}

//Function get Khách Hàng và pets thông tin đầy đủ
if ($data['action'] == 'getKhachHangWithPets'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
            $result = $khachHang->getKhachHangWithPets($data['_id']);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseSuccess(null);
        }
        
    } else {
        ResponseHelper::responseSuccess(null);
    }

}


//Function Get All Khách Hàng và pet với thông tin đầy đủ có phân trang và kw
if ($data['action'] == 'getAllKhachHang' ){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['page'])){
        try{
            
            if (empty($data['kw'])){
                $result = $khachHang->getAllKhachHang($data['page']);
            } else {
                $result = $khachHang->getAllKhachHang($data['page'],$data["kw"]);
            }
            
            ResponseHelper::responseSuccess($result);

        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }
    } else {
        ResponseHelper::responseError("Get Fail");
    }
} 
?>