<?php

// ===== CORS ALLOW ALL =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

#############################################################################

require_once 'vendor/autoload.php';

require_once 'model/ChiNhanh.php';
require_once 'model/ChuyenXuatKho.php';
require_once 'model/Inventory.php';
require_once 'model/NhapHangKho.php';
require_once 'model/KiemToanKho.php';

require_once 'controller/ResponseHelper.php';

use Symfony\Component\HttpFoundation\Request;

$request = Request::createFromGlobals();

if (!in_array($request->getMethod(),['POST','GET'])) {
    ResponseHelper::responseError("Only POST method allowed");
}  

// Đọc dữ liệu JSON gửi lên
$data = json_decode($request->getContent(), true);

// Kiểm tra dữ liệu hợp lệ
if (!$data || !isset($data['action'])) {
    ResponseHelper::responseError("Invalid input, required field: action");
}

$chiNhanh = new ChiNhanh();
$inventory = new Inventory();
$chuyenXuatKho = new ChuyenXuatKho();
$nhapHangKho = new NhapHangKho();
$kiemToanKho = new KiemToanKho();

#############################################################################

//Fucntion lấy tất cả inventory theo chi nhánh 
if ($data['action'] == 'getAllInventory'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data["page"]) && !empty($data["id_chi_nhanh"])){
        try{
            $result = $inventory->getAllInventory($data);     
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }

    } else {
        ResponseHelper::responseError("Get Fail");
    }
}

//Function add Nhập hàng kho
if ($data['action'] == 'addNhapHangKho'){

    //Xoá action để thêm data vào 
    unset($data['action']);
   
    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            
            $result = $nhapHangKho->addNhapHangKho($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }
        
}

//Function xuất kho
if ($data['action'] == 'addXuatKho'){

    //Xoá action để thêm data vào 
    unset($data['action']);
   
    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            $result = $chuyenXuatKho->addXuatKho($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }
        
}


//Function chuyển hàng sang kho khác 
if ($data["action"] == "addChuyenKho"){

    //Xoá action để thêm data vào 
    unset($data['action']);
   
    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            $result = $chuyenXuatKho->addChuyenKho($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }

}

//Function kiểm tra tồn kho
if ($data["action"] == "addKiemToanKho"){

    //Xoá action để thêm data vào 
    unset($data['action']);
   
    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            $result = $kiemToanKho->addKiemToanKho($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }

}


//Function getAll chuyển xuất kho 
if ($data["action"] == "getAllChuyenXuatKho"){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            $result = $chuyenXuatKho->getAllChuyenXuatKho($data["id_chi_nhanh"], $data["page"]);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }
}

//Function getAll  kiểm toán kho
if ($data["action"] == "getAllKiemToanKho"){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            $result = $kiemToanKho->getAllKiemToanKho($data["id_chi_nhanh"], $data["page"]);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }
}


//Function getAll nhâp hàng kho
if ($data["action"] == "getAllNhapHangKho"){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (empty($data["id_chi_nhanh"])){
        ResponseHelper::responseError("All Fail");
    } else{
        try{
            $result = $nhapHangKho->getAllNhapHangKho($data["id_chi_nhanh"], $data["page"]);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("All Fail");
        }
    }
}

//Function get Inventory 
if ($data["action"] == "getInventory"){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

     if (!empty($data["id_hang_hoa"]) && !empty($data["id_chi_nhanh"])){
        try{
            $result = $inventory->getInventory($data["id_chi_nhanh"], $data["id_hang_hoa"]);     
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }

    } else {
        ResponseHelper::responseError("Get Fail");
    }

}
