<?php

// ===== CORS ALLOW ALL =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

#############################################################################

require_once 'vendor/autoload.php';

require_once 'model/HangHoa.php';
require_once 'model/DonVi.php';
require_once 'model/CachDung.php';
require_once 'model/NhaSanXuat.php';
require_once 'model/PhanLoai.php';

require_once 'controller/ResponseHelper.php';

use Symfony\Component\HttpFoundation\Request;


$request = Request::createFromGlobals();

if (!in_array($request->getMethod(),['POST','GET'])) {
    ResponseHelper::responseError("Only POST method allowed");
}  

// Đọc dữ liệu JSON gửi lên
$data = json_decode($request->getContent(), true);

// Kiểm tra dữ liệu hợp lệ
if (!$data || !isset($data['action'])) {
    ResponseHelper::responseError("Invalid input, required field: action");
}

$hangHoa = new HangHoa();
$donVi = new DonVi();
$cachDung = new CachDung();
$nhaSanXuat = new NhaSanXuat();
$phanLoai = new PhanLoai();

#############################################################################

//Function thêm đơn vị
if ($data['action'] == 'addDonVi'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['ten_don_vi'])) && (!empty($data['type']))){
        try{
            $result = $donVi->addDonVi($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa đơn vị
if ($data['action'] == 'updateDonVi'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $donVi->updateDonVi($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Fucntion lấy tất cả đơn vị
if ($data['action'] == 'getAllDonVi'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $donVi->getAllDonVi($data["type"]);
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}

#############################################################################

//Function thêm cách dùng 
if ($data['action'] == 'addCachDung'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['ten_cach_dung'])){
        try{
            $result = $cachDung->addCachDung($data['ten_cach_dung']);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa cách dùng
if ($data['action'] == 'updateCachDung'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $cachDung->updateCachDung($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Fucntion lấy tất cả cách dùng
if ($data['action'] == 'getAllCachDung'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $cachDung->getAllCachDung();
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}

#############################################################################


//Function thêm phân loại
if ($data['action'] == 'addPhanLoai'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['ten_phan_loai'])) && (!empty($data['type']))){
        try{
            $result = $phanLoai->addPhanLoai($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa phân loại
if ($data['action'] == 'updatePhanLoai'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $phanLoai->updatePhanLoai($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Fucntion lấy tất cả cách dùng
if ($data['action'] == 'getAllPhanLoai'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $phanLoai->getAllPhanLoai($data["type"]);
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}

#############################################################################

//Function thêm nhà sản xuất
if ($data['action'] == 'addNhaSanXuat'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['ten_nha_san_xuat']) && (!empty($data['type']))){
        try{
            $result = $nhaSanXuat->addNhaSanXuat($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa nhà sản xuất
if ($data['action'] == 'updateNhaSanXuat'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);

    try{
        $result = $nhaSanXuat->updateNhaSanXuat($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Fucntion lấy tất cả nhà sản xuất
if ($data['action'] == 'getAllNhaSanXuat'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    try{
        $result = $nhaSanXuat->getAllNhaSanXuat($data["type"]);
        ResponseHelper::responseSuccess($result);
    }   catch (Throwable $e) {
        ResponseHelper::responseError("Get All Fail");
    }
    
}

//Function xoá nhà sản xuất theo _id
if ($data['action'] == 'deleteNhaSanXuat'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
            $result = $nhaSanXuat->deleteNhaSanXuat($data['_id']);
            
            if ($result == 1){
                ResponseHelper::responseSuccess($result);
            }else {
                ResponseHelper::responseError("Delete Fail");
            }
        } catch (Throwable  $e){
            ResponseHelper::responseError("Delete Fail");
        }
    } else {
        ResponseHelper::responseError("Delete Fail");
    }
}


#############################################################################

//Function thêm hàng hoá
if ($data['action'] == 'addHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if ((!empty($data['ten_hang_hoa'])) && (!empty($data['gia_ban']))){
        try{
            $result = $hangHoa->addHangHoa($data);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseError("Add Fail");
        }
    } else {
        ResponseHelper::responseError("Add Fail");
    }
}

//Function sửa hàng hoá
if ($data['action'] == 'updateHangHoa'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);

    
    try{
        $result = $hangHoa->updateHangHoa($id, $data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }

    
    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//Function delete hàng hoá theo _id
if ($data['action'] == 'deleteHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
            $result = $hangHoa->deleteHangHoa($data['_id']);
            
            if ($result == 1){
                ResponseHelper::responseSuccess($result);
            }else {
                ResponseHelper::responseError("Delete Fail");
            }
        } catch (Throwable  $e){
            ResponseHelper::responseError("Delete Fail");
        }
    } else {
        ResponseHelper::responseError("Delete Fail");
    }
}

//Function get Hàng hoá theo _id 

if ($data['action'] == 'getHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
        
            $result = $hangHoa->getHangHoa($data['_id']);
            ResponseHelper::responseSuccess($result);

        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }
    } else {
        ResponseHelper::responseError("Get Fail");
    }
}

//Function get nhiều hàng hoá theo page

if ($data['action'] == 'getAllHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['page'])){
        try{
            
            $result = $hangHoa->getAllHangHoa($data);
            ResponseHelper::responseSuccess($result);

        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }
    } else {
        ResponseHelper::responseError("Get Fail");
    }
}
?>