<?php


// ===== CORS ALLOW ALL =====
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

#############################################################################

require_once 'vendor/autoload.php';

require_once 'model/HangHoa.php';
require_once 'model/DichVu.php';

require_once 'controller/ResponseHelper.php';

use Symfony\Component\HttpFoundation\Request;


$request = Request::createFromGlobals();

if (!in_array($request->getMethod(),['POST','GET'])) {
    ResponseHelper::responseError("Only POST method allowed");
}  

// Đọc dữ liệu JSON gửi lên
$data = json_decode($request->getContent(), true);

// Kiểm tra dữ liệu hợp lệ
if (!$data || !isset($data['action'])) {
    ResponseHelper::responseError("Invalid input, required field: action");
}

$hangHoa = new HangHoa();
$dichVu = new DichVu();

#############################################################################

//function autoComplete HangHoa
if ($data['action'] == 'autoCompleteHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['kw'])){
        try{
            $result = $hangHoa->autoCompleteHangHoa($data['kw']);
            ResponseHelper::responseSuccess($result);
        } catch (Throwable  $e){
            ResponseHelper::responseSuccess(null);
        }
        
    } else {
        ResponseHelper::responseSuccess(null);
    }
}


//Function get Hàng hoá theo _id 

if ($data['action'] == 'getHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
        
            $result = $hangHoa->getHangHoa($data['_id'],"part-detail");
            ResponseHelper::responseSuccess($result);

        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }
    } else {
        ResponseHelper::responseError("Get Fail");
    }
}

//function add Dịch Vụ
if ($data['action'] == 'addDichVu'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!(isset($data["ten_dich_vu"]) && !empty($data["ten_dich_vu"]))){
        ResponseHelper::responseError("Update Fail");
    }

    try{
        $result = $dichVu->addDichVu($data);
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Add Fail");
    }
    

    if ($result == false){
        ResponseHelper::responseError("Add Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }

}

//function update Dịch Vụ
if ($data['action'] == 'updateDichVu'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);


    if (!(isset($data["_id"]) && !empty($data["_id"]))){
        ResponseHelper::responseError("Update Fail");
    }

    $id = $data["_id"];
    unset($data["_id"]);


    try{
        $result = $dichVu->updateDichVu($id, $data);
    
    }   catch (Throwable  $e) {
        ResponseHelper::responseError("Update Fail");
    }


    if ($result == 0 ){
        ResponseHelper::responseError("Update Fail");
    } else{
        ResponseHelper::responseSuccess($result);
    }
}

//Function autoComplete Hàng Hoá
if ($data['action'] == 'autoCompleteHangHoa'){

    //Xoá action để thêm data vào 
    unset($data['action']);


}

//Funtion Get Dịch vụ theo _id

if ($data['action'] == 'getDichVu'){
    
    //Xoá action để thêm data vào 
    unset($data['action']);

    if (!empty($data['_id'])){
        try{
            if (empty($data["option_name"]))
                $result = $dichVu->getDichVu($data['_id']);
            else 
                $result = $dichVu->getDichVu($data['_id'],$data["option_name"]);
            ResponseHelper::responseSuccess($result);

        } catch (Throwable  $e){
            ResponseHelper::responseError("Get Fail");
        }
    } else {
        ResponseHelper::responseError("Get Fail");
    }

}

//Function get All Dich Vụ theo page có kw hoặc không 

if ($data['action'] == 'getAllDichVu'){

    //Xoá action để thêm data vào 
    unset($data['action']);

    if (empty($data["page"]))
        ResponseHelper::responseError("Get Fail");
    
    try{
        $result = $dichVu->getAllDichVu($data);
        ResponseHelper::responseSuccess($result);

    } catch (Throwable  $e){
        ResponseHelper::responseError("Get Fail");
    }
}

//Function xoá Dịch vụ theo _id

if ($data['action'] == 'deleteDichVu'){


    //Xoá action để thêm data vào 
    unset($data['action']);
    if (!empty($data['_id'])){
        try{
            
            $result = $dichVu->deleteDichVu($data['_id']);
            
            if ($result == 1){
                ResponseHelper::responseSuccess($result);
            }else {
                ResponseHelper::responseError("Delete Fail");
            }
        } catch (Throwable  $e){
            ResponseHelper::responseError("Delete Fail");
        }
    } else {
        ResponseHelper::responseError("Delete Fail");
    }
}

?>